// 热带雨林生物智能问答系统 - 配置文件

const API_CONFIG = {
    // 火山方舟API配置
    volcano: {
        apiUrl: 'https://ark.cn-beijing.volces.com/api/v3/chat/completions',
        apiKey: '38e258f3-266f-45a7-b07d-dbdec0aa413c',
        model: 'ep-20251015113513-b7rvf'
    },
    // 备用模式：如果直接API调用失败，使用本地知识库
    useLocalFallback: true
};

// 动物问题建议库
const QUESTION_SUGGESTIONS = {
    "树懒": [
        "你为什么动作这么慢？", 
        "你住在雨林的哪一层？", 
        "你喜欢吃什么？", 
        "你有哪些天敌？",
        "你一天睡多久？"
    ],
    "五彩金刚鹦鹉": [
        "你的羽毛为什么这么漂亮？", 
        "你住在雨林的哪一层？", 
        "你喜欢吃什么？", 
        "你是怎么飞翔的？",
        "你的寿命有多长？"
    ],
    "食蚁兽": [
        "你为什么喜欢吃蚂蚁？", 
        "你的长舌头有什么用？", 
        "你住在雨林的哪一层？", 
        "你的爪子有什么特别？",
        "你一天能吃多少蚂蚁？"
    ],
    "蜂鸟": [
        "你为什么飞得这么快？", 
        "你喜欢吃什么？", 
        "你住在雨林的哪一层？", 
        "你的翅膀有什么特别？",
        "你是怎么采蜜的？"
    ],
    "长臂猿": [
        "你的长手臂有什么用？", 
        "你住在雨林的哪一层？", 
        "你喜欢吃什么？", 
        "你是怎么在树间移动的？",
        "你会唱歌吗？"
    ],
    "巨蚺": [
        "你有多大？", 
        "你喜欢吃什么？", 
        "你住在雨林的哪一层？", 
        "你是怎么捕猎的？",
        "你会游泳吗？"
    ],
    "火烈鸟": [
        "你的羽毛为什么是粉红色的？", 
        "你住在雨林的哪一层？", 
        "你喜欢吃什么？", 
        "你的长腿有什么用？",
        "你们为什么喜欢群居？"
    ]
};


// 本地备用知识库
const KNOWLEDGE_BASE = {
    "树懒": {
        "default": "我是树懒，我生活在雨林的冠层。我动作很慢，这样可以节省能量，也不容易被天敌发现哦！",
        "慢": "我动作慢是因为我吃的树叶能量很低，慢慢行动才能活下去。而且这样不容易被老鹰发现！",
        "住": "我住在高高的冠层，整天抱着树枝，在树叶间慢慢移动。",
        "吃": "我最爱吃树叶、嫩芽和果实，树上的美食多着呢！",
        "睡": "我一天要睡15-18个小时，这样才能节省能量。"
    },
    "五彩金刚鹦鹉": {
        "default": "我是五彩金刚鹦鹉，我住在雨林的露生层。我的羽毛很漂亮，红色蓝色黄色都有！",
        "颜色": "我的漂亮羽毛是为了在茂密的雨林中吸引伴侣，也和同伴交流。",
        "住": "我住在高高的露生层和冠层，那里阳光充足！",
        "吃": "我最爱吃水果、坚果和种子，用我强壮的喙轻松敲开坚硬的果壳！",
        "飞": "我展开宽大的翅膀，在雨林上空优雅地飞翔！"
    },
    "食蚁兽": {
        "default": "我是食蚁兽，我主要生活在地面上。我最爱吃蚂蚁了！",
        "蚂蚁": "我的长舌头可以伸进蚁穴，一次能粘住好多蚂蚁呢！",
        "住": "我住在地表层，靠近蚂蚁巢穴的地方。",
        "舌头": "我的舌头有60厘米长，上面有粘粘的唾液，可以轻松捕捉蚂蚁。"
    },
    "蜂鸟": {
        "default": "我是蜂鸟，我是世界上最小的鸟类之一！我飞得可快了！",
        "快": "我的翅膀每秒可以振动50次以上，所以我能悬停在空中！",
        "住": "我住在冠层的花丛中，那里有我最爱的花蜜。",
        "吃": "我用细长的嘴巴吸食花蜜，偶尔也吃小昆虫。"
    },
    "长臂猿": {
        "default": "我是长臂猿，我有长长的手臂，可以在树间轻松摆荡！",
        "手臂": "我的手臂比腿还长，这样我就能在树冠层快速移动了！",
        "住": "我住在冠层，很少下到地面。",
        "吃": "我最爱吃浆果，也吃树叶和小鸟。"
    },
    "巨蚺": {
        "default": "我是巨蚺，我是雨林中最大的蛇类之一！",
        "大": "我可以长到5米长，比我的一些天敌还要大呢！",
        "住": "我住在地表层和灌木层，喜欢靠近水源。",
        "吃": "我捕食哺乳动物和鸟类，用身体缠绕让它们窒息。"
    },
    "火烈鸟": {
        "default": "我是火烈鸟，我有着漂亮的粉红色羽毛和长长的腿！",
        "颜色": "我的粉红色羽毛是因为我吃的小虾和藻类含有红色素！",
        "住": "我生活在雨林中的湿地和水边。",
        "吃": "我最爱吃小虾、蛤蜊和藻类，用我特别的嘴巴过滤食物！",
        "腿": "我的长腿让我能在浅水中行走，寻找美味的食物！"
    }
};

// 动物数据配置
const ANIMALS_DATA = [
    {
        name: "树懒",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef687bd577b.jpg",
        alt: "树懒"
    },
    {
        name: "五彩金刚鹦鹉",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef6880426a6.jpg",
        alt: "五彩金刚鹦鹉"
    },
    {
        name: "食蚁兽",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef687b65886.jpg",
        alt: "食蚁兽"
    },
    {
        name: "蜂鸟",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef687b6b808.jpg",
        alt: "蜂鸟"
    },
    {
        name: "长臂猿",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef68809bbb9.jpg",
        alt: "长臂猿"
    },
    {
        name: "巨蚺",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef687b81f57.jpg",
        alt: "巨蚺"
    },
    {
        name: "火烈鸟",
        image: "https://youke1.picui.cn/s1/2025/10/15/68ef687b9d4f7.jpg",
        alt: "火烈鸟"
    }
];
